//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function [q3]=%CLquat_m_CLquat(q1,q2)

// LAST UPDATE
// 02/05/2007
//
// Authors
// CNES - DCT/SB
//

// Declarations:


// Code:

if size(q1)==size(q2) then
  R=q1.r.*q2.r - sum(q1.i.*q2.i,1);
  I1=q1.r.*q2.i(1,:) + q2.r.*q1.i(1,:) + q1.i(2,:).*q2.i(3,:) - q1.i(3,:).*q2.i(2,:);
  I2=q1.r.*q2.i(2,:) + q2.r.*q1.i(2,:) + q1.i(3,:).*q2.i(1,:) - q1.i(1,:).*q2.i(3,:);
  I3=q1.r.*q2.i(3,:) + q2.r.*q1.i(3,:) + q1.i(1,:).*q2.i(2,:) - q1.i(2,:).*q2.i(1,:);
  q3=CL_rot_defQuat(R,I1,I2,I3);
else
  CL__error("check dimension of input quaternions");
end

endfunction
